/*-----------------------------------------------------------------------------
 * LinkHnx.h				header file
 * Copyright                acontis technologies GmbH, Weingarten, Germany
 * Response                 Andreas Willig
 * Description              interface to the HNX link layer
 *---------------------------------------------------------------------------*/

#ifndef INC_LINKHNX
#define INC_LINKHNX

/*-INCLUDE-------------------------------------------------------------------*/

#include "EcLink.h"
#include "EcType.h"

#include "acontis_netx.h"

/*-DEFINES-------------------------------------------------------------------*/


#define EC_LINK_TYPE_HNX	0xA1ECA103

#define HNX0_ARRAYIDX_INIT	{ \
	EC_LINK_TYPE_HNX, 0, EcLinkMode_INTERRUPT, \
	NETX_ASIC_CTRL_BASE_VADRS, NETX_MIIMU_BASE_VADRS, \
	NETX_XPEC0_BASE_VADRS, NETX_XPEC0_BASE_PADRS, \
	NETX_XPEC0_IRQ_VADRS, NETX_XMAC0_BASE_VADRS, \
	NETX_XMAC0_BASE_PADRS, NETX_SRAM0_UC_VADRS, \
	NETX_PTR_FIFO_VADRS, NETX_SYSTIME_BASE_VADRS, \
	10, EC_NULL, EC_NULL, EC_NULL, \
	INT_LVL_COM0, {0x00, 0x0A, 0x5E, 0x42, 0xBE, 0xAC}, \
    EC_FALSE, EC_FALSE, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00} }

#define HNX1_ARRAYIDX_INIT	{ \
	EC_LINK_TYPE_HNX, 1, EcLinkMode_INTERRUPT, \
	NETX_ASIC_CTRL_BASE_VADRS, NETX_MIIMU_BASE_VADRS, \
	NETX_XPEC1_BASE_VADRS, NETX_XPEC1_BASE_PADRS, \
	NETX_XPEC1_IRQ_VADRS, NETX_XMAC1_BASE_VADRS, \
	NETX_XMAC1_BASE_PADRS, NETX_SRAM1_UC_VADRS, \
	NETX_PTR_FIFO_VADRS, NETX_SYSTIME_BASE_VADRS, \
	10, EC_NULL, EC_NULL, EC_NULL, \
	INT_LVL_COM1, {0x00, 0x0A, 0x5E, 0x42, 0xBE, 0xAF}, \
    EC_FALSE, EC_FALSE, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00} }
    
/*-TYPEDEFS/ENUMS------------------------------------------------------------*/

typedef EC_T_DWORD (*PFHANDLEINT)(EC_T_PVOID);
typedef EC_T_DWORD (*PFISRCALLBACK)(EC_T_PVOID, EC_T_PVOID);

/* Link parameters */

typedef struct _EC_T_LINK_OPENPARMS_HNX
{
  EC_T_DWORD    dwType;
	EC_T_DWORD		dwPortNr;
  EC_T_LINKMODE eLinkMode;
	EC_T_DWORD		dwAsicCtrlAdr;
	EC_T_DWORD		dwMiiMuVirtAdr;
	EC_T_DWORD		dwXPecVirtAdr;
	EC_T_DWORD		dwXPecPhysAdr;
	EC_T_DWORD		dwXPecIrqVAdr;
	EC_T_DWORD		dwXMacVirtAdr;
	EC_T_DWORD		dwXMacPhysAdr;
	EC_T_DWORD		dwIntRamStart;
	EC_T_DWORD		dwFifoPointer;
	EC_T_DWORD		dwSysTimeVirtAddr;
  EC_T_DWORD    dwSendBuffers;
	PFISRCALLBACK pfIsrCallback;		/* [in]		optional called by ISR */
	EC_T_PVOID		pvIsrCBContext;		/* [in]		ISR callback context */
	PFHANDLEINT   pfDoIntHandling;	/* [out]	interrupt processing routine for ext IntHandling */
	EC_T_INT		  nIntLevel;
	EC_T_BYTE		  byMacAddr[6];
  EC_T_BOOL     bPromiscuousMode;   /* [in]     if TRUE promiscuous mode is activated */
  EC_T_BOOL     bSetMulticast;      /* [in]     if TRUE multicast is programmed */
  EC_T_BYTE     byMCMacAddr[6];     /* [in]     MAC Address to add to multicast list */
} EC_T_LINK_OPENPARMS_HNX;


#endif /* INC_LINKHNX */

/*-END OF SOURCE FILE--------------------------------------------------------*/
